/*
 Basic ESP32 MQTT example
 This sketch demonstrates the capabilities of the pubsub library in combination
 with the ESP8266 board/library.
 It connects to an MQTT server then:
  - publishes "hello world" to the topic "outTopic" every two seconds
  - subscribes to the topic "inTopic", printing out any messages
    it receives. NB - it assumes the received payloads are strings not binary
  - If the first character of the topic "inTopic" is an 1, switch ON the ESP Led,
    else switch it off
 It will reconnect to the server if the connection is lost using a blocking
 reconnect function. See the 'mqtt_reconnect_nonblocking' example for how to
 achieve the same result without blocking the main loop.
 To install the ESP8266 board, (using Arduino 1.6.4+):
  - Add the following 3rd party board manager under "File -> Preferences -> Additional Boards Manager URLs":
       http://arduino.esp8266.com/stable/package_esp8266com_index.json
  - Open the "Tools -> Board -> Board Manager" and click install for the ESP8266"
  - Select your ESP8266 in "Tools -> Board"
*/

#include <WiFiS3.h>
#include <PubSubClient.h>

#define BUILTIN_LED 13


// Update these with values suitable for your network.
#include "arduino_secrets.h" 
///////please enter your sensitive data in the Secret tab/arduino_secrets.h
char ssid[] = SECRET_SSID;        // your network SSID (name)
char pass[] = SECRET_PASS;    // your network password (use for WPA, or use as key for WEP)
int status = WL_IDLE_STATUS;     // the WiFi radio's status


const char* mqtt_server = "broker.emqx.io"; //"broker.hivemq.com" //"broker.emqx.io"; //"broker.mqtt-dashboard.com";

WiFiClient unoClient;
PubSubClient client(unoClient);

unsigned long lastMsg = 0;
#define MSG_BUFFER_SIZE	(50)
char msg[MSG_BUFFER_SIZE];
int value = 0;

void setup_wifi() {

  WiFi.disconnect();  // resetuje WiFi koprocesor
  //delay(1000);      // opcionalna pauza  

  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);

  // check for the WiFi module:
  if (WiFi.status() == WL_NO_MODULE) {
    Serial.println("Communication with WiFi module failed!");
    // don't continue
    while (true);
  }

  String fv = WiFi.firmwareVersion();
  if (fv < WIFI_FIRMWARE_LATEST_VERSION) {
    Serial.println("Please upgrade the firmware");
  }

  // attempt to connect to WiFi network:
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to WPA SSID: ");
    Serial.println(ssid);
    // Connect to WPA/WPA2 network:
    if(strlen(pass)!=0)status = WiFi.begin(ssid, pass);
    else status = WiFi.begin(ssid);

    // wait 1 second for connection:
    delay(1000);
  }

  // you're connected now, so print out the data:
  Serial.print("You're connected to the network");

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  while (WiFi.localIP().toString() == "0.0.0.0") {
    delay(500);
    Serial.println("Waiting for valid IP...");
  }  
  Serial.println(WiFi.localIP());
}

void callback(char* topic, byte* payload, unsigned int length) {
  String Msg;

  Serial.print("Message arrived [");
  Serial.print(topic);
  Serial.print("] ");
  //for (int i = 0; i < length; i++) {
  //  Serial.print((char)payload[i]);
  //}
  Msg=String((char *)payload);
  Msg=Msg.substring(0, length);
  Serial.println(Msg);

  if(!strcmp(topic,"komande"))
  {
    // Switch on the LED if an 1 was received as first character
    if (Msg.indexOf("LEDON")!=(-1)){
      digitalWrite(BUILTIN_LED, HIGH);
      Serial.print("Publish message: ");
      Serial.println("Ukljucena LED");
      client.publish("izvjestaj", "Ukljucena LED");
    }
    else if (Msg.indexOf("LEDOFF")!=(-1)){
      digitalWrite(BUILTIN_LED, LOW);
      Serial.print("Publish message: ");
      Serial.println("Iskljucena LED");      
      client.publish("izvjestaj", "Isključena LED");
    }
    else if (Msg.length() >0){
      Serial.print("Publish message: ");
      Serial.println("Ne lupaj!");      
      client.publish("izvjestaj", "Ne lupaj!");
    }     
  }
  if(!strcmp(topic,"poruke"))
  {
    // Switch on the LED if an 1 was received as first character
    if (Msg.indexOf("HELLO")!=(-1)){
      Serial.print("Publish message: ");
      Serial.println("Hi!");
      client.publish("odgovor", "Hi!");
    }
    else if (Msg.indexOf("Kako ide")!=(-1)){
      Serial.print("Publish message: ");
      Serial.println("Evo po malo.");      
      client.publish("odgovor", "Evo po malo. :)");
    }
    else if (Msg.length() >0){
      Serial.print("Publish message: ");
      Serial.println("Ne lupaj!");      
      client.publish("odgovor", "Ne lupaj!");
    }
  }
}

void reconnect() {
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
    // Create a random client ID
    String clientId = "unoR4_pubsub";
    clientId += String(random(0xffff), HEX);
    // Attempt to connect
    if (client.connect(clientId.c_str())) {
      Serial.println("connected");
      // Once connected, publish an announcement...
      client.publish("startTopic", "Povezan sam!");
      // ... and resubscribe
      client.subscribe("poruke");
      client.subscribe("komande");
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}

void setup() {
  pinMode(BUILTIN_LED, OUTPUT);     // Initialize the BUILTIN_LED pin as an output
  Serial.begin(115200);
  setup_wifi();

  client.setServer(mqtt_server, 1883);
  client.setCallback(callback);
}

void loop() {

  if (!client.connected()) {
    reconnect();
  }
  client.loop();

  unsigned long now = millis();
  if (now - lastMsg > 2000) {
    lastMsg = now;
    ++value;
    snprintf (msg, MSG_BUFFER_SIZE, "Tesla Wifi #%ld", value);
    Serial.print("Publish message: ");
    Serial.println(msg);
    client.publish("outoutTopic", msg);
  }
}
